var connection = require("./connection.js")

module.exports = class StratasysFortus{
	connectionWarned = false
	
	constructor(options){
		this.connectionOptions = {}
		
		if(!options.host){
			throw new Error("option host is not defined")
		}
		this.connectionOptions.host = options.host
		
		// override type to match others
		this.type = "3d-printer"
	}
	
	async getDeviceInfo(){
		var out = {}
		out.title = "Stratasys Fortus"
		
		try{
			var rawText = await connection.getRawMachineInfo(this.connectionOptions)
			var info = connection.parser(rawText)
		}catch(err){
			if(!this.connectionWarned){
				console.error(err)
				console.error("Could not connect to " + this.connectionOptions.host)
				this.connectionWarned = true
			}
			out.status = "Disconnected"
			out.values_overview = {}
			out.values_overview.status = {
				type: "value",
				title:"Status",
				value: "Disconnected",
			}
			return [out]
		}
		
		
		if(!info || !info.general){
			return []
		}
		
		
		
		out.status = info.general.modelerStatus
		
		out.values = {}
		out.values_overview = {}
		
		if(out.status){
			out.values_overview.status = {
				type:"value",
				title:"Status",
				value: out.status,
			}
		}
		
		//info.currentJob = info.previousJob
		if(info.currentJob && (info.currentJob.guid || info.currentJob.jobid)){
			out.values.time = {
				type:"bar",
				title: "Time",
				usage: info.currentJob.buildTime / info.currentJob.estimatedBuildTime * 100,
				//value: info.currentJob.buildTime / 60 / 60,
				//value_limit: info.currentJob.buildTime / 60 / 60,
				//unit: "h",
				value: info.currentJob.buildTime,
				value_limit: info.currentJob.estimatedBuildTime,
				unit: "time",
			}
			out.values_overview.time = out.values.time
			out.values.layers = {
				type:"bar",
				title: "Layers",
				usage: info.currentJob.currentLayer / info.currentJob.totalLayers * 100,
				value: info.currentJob.currentLayer,
				value_limit: info.currentJob.totalLayers,
			}
		}
		
		if(info.queue){
			out.values.queue = {
				type:"value",
				title: "Queue",
				value: info.queue.length,
				unit: info.queue.length == 1 ? "job" : "jobs",
				decimals: 0,
			}
			out.values_overview.queue = out.values.queue
		}
		
		var outSpools = {}
		outSpools.title = "Spools"
		outSpools.values = {}
		for(var x in info.cassette){
			var spool = info.cassette[x]
			if(spool.initialMatl > 0){
				outSpools.values["material_" + spool.spool] = {
					type: "donut",
					title: "Spool " + spool.spool,
					usage: spool.remainingMatl / spool.initialMatl * 100,
					description: spool.name,
				}
			}
		}
		
		var outTemps = {}
		outTemps.title = "Temperatures"
		outTemps.values = {}
		outTemps.values.temp_tip_0 = {
			type: "bar",
			title: "Main Tip",
			usage: info.general.partCurrentTemp / info.general.partSetTemp * 100,
			value: info.general.partCurrentTemp,
			value_limit: info.general.partSetTemp,
			unit: "°C",
		}
		outTemps.values.temp_tip_support = {
			type: "bar",
			title: "Support Tip",
			usage: info.general.supportCurrentTemp / info.general.supportSetTemp * 100,
			value: info.general.supportCurrentTemp,
			value_limit: info.general.supportSetTemp,
			unit: "°C",
		}
		outTemps.values.temp_enclosure= {
			type: "bar",
			title: "Enclosure",
			usage: info.general.envelopeCurrentTemp / info.general.envelopeSetTemp * 100,
			value: info.general.envelopeCurrentTemp,
			value_limit: info.general.envelopeSetTemp,
			unit: "°C",
		}
		
		
		var outTips = {}
		outTips.title = "Tips"
		outTips.values = {}
		outTips.values.tip_0 = {
			type: "value",
			title: "Main Tip",
			value: info.general.partTip + "\n" + info.lffs?.modelTipOdometer + " f ³",
		}
		outTips.values.tip_support = {
			type: "value",
			title: "Support Tip",
			value: info.general.supportTip + "\n" + info.lffs?.supportTipOdometer + " f ³",
		}
		
		return [out, outSpools, outTemps, outTips]
	}
}