//@ts-check

var net = require("net")

function getRawMachineInfo(options){
	options = options || {}
	options.port = options.port || 53742
	return new Promise(function(resolve,reject){
		var connection = net.createConnection({
			host: options.host,
			port: options.port
		})
		
		var infoReceiving = false
		var dataTextFull = ""
		connection.on("data",function(data){
			//console.log(data.toString())
			var dataString = data.toString()
			if(dataString.substring(0,8) == "SendFile"){
				connection.write(Buffer.from([
					0x4f, 0x4b, 0x00, 0x00, 0x5c, 0x00, 0x50, 0x00, 
					0x52, 0x00, 0x4f, 0x00, 0x47, 0x00, 0x52, 0x00, 
					0x41, 0x00, 0x7e, 0x00, 0x33, 0x00, 0x5c, 0x00, 
					0x53, 0x00, 0x54, 0x00, 0x52, 0x00, 0x41, 0x00, 
					0x54, 0x00, 0x41, 0x00, 0x7e, 0x00, 0x31, 0x00, 
					0x5c, 0x00, 0x4d, 0x00, 0x4f, 0x00, 0x44, 0x00, 
					0x45, 0x00, 0x4c, 0x00, 0x53, 0x00, 0x7e, 0x00, 
					0x31, 0x00, 0x5c, 0x00, 0x31, 0x00, 0x36, 0x00
				]))
				connection.write(Buffer.from([
					0x4f, 0x4b, 0x00, 0x00, 0x5c, 0x00, 0x50, 0x00, 
					0x52, 0x00, 0x4f, 0x00, 0x47, 0x00, 0x52, 0x00, 
					0x41, 0x00, 0x7e, 0x00, 0x33, 0x00, 0x5c, 0x00, 
					0x53, 0x00, 0x54, 0x00, 0x52, 0x00, 0x41, 0x00, 
					0x54, 0x00, 0x41, 0x00, 0x7e, 0x00, 0x31, 0x00, 
					0x5c, 0x00, 0x4d, 0x00, 0x4f, 0x00, 0x44, 0x00, 
					0x45, 0x00, 0x4c, 0x00, 0x53, 0x00, 0x7e, 0x00, 
					0x31, 0x00, 0x5c, 0x00, 0x31, 0x00, 0x36, 0x00
				]))
			}
			if(dataString.substring(0,4) == "5458"){
				
			}
			//console.log(dataString.substring(0,4))
			
			
			if(infoReceiving){
				dataTextFull += dataString
			}
			
			var setIndex = dataString.indexOf("set")
			if(setIndex != -1 && !infoReceiving){
				infoReceiving = true
				dataTextFull = dataString.substring(setIndex)
				setTimeout(function(){
					resolve(dataTextFull)
					connection.end()
				},50)
			}
		})
		
		connection.write(Buffer.from([
			0x47, 0x65, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x00, 
			0x40, 0xe5, 0xf5, 0x22, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
			0x40, 0x17, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0xc4, 0x02, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x60, 0xe5, 0xf5, 0x22, 0x00, 0x00, 0x00, 0x00
		]))
		connection.write(Buffer.from([
			0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x73, 
			0x74, 0x73, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
			0x40, 0x17, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0xc4, 0x02, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x60, 0xe5, 0xf5, 0x22, 0x00, 0x00, 0x00, 0x00, 
			0x4e, 0x41, 0x00, 0x74, 0x75, 0x73, 0x2e, 0x73, 
			0x74, 0x73, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 
			0x40, 0x17, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0xc4, 0x02, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x60, 0xe5, 0xf5, 0x22, 0x00, 0x00, 0x00, 0x00
		]))
		
		connection.on("error",function(err){
			reject(err)
		})
		
		setTimeout(function(){
			reject(new Error("Timeout"))
			connection.end()
		},200)
	})
}

/**
 * 
 * @param {string} rawText 
 */
function parser(rawText){
	var lines = rawText.split("\n")
	lines = lines.map(function(line){return line.trim()})
	var output = Object.create(null)
	var currentObj = Object.create(null)
	var currentArray = []
	for(var x in lines){
		var line = lines[x]
		if(line == ""){
			continue
		}
		if(line.substring(0,4) == "set "){
			var indexStart = line.indexOf("(") + 1
			var indexEnd = line.indexOf(")",indexStart)
			var objName = line.substring(indexStart,indexEnd)
			if(lines[parseInt(x) + 1] == "{"){
				// start of array
				currentArray = []
				output[objName] = currentArray
			}else{
				// start of object
				currentObj = Object.create(null)
				output[objName] = currentObj
			}
		}
		if(line == "{"){
			currentObj = Object.create(null)
			currentArray.push(currentObj)
		}
		if(line[0] == "-"){
			var spaceIndex = line.indexOf(" ")
			var name = line.substring(1,spaceIndex)
			var value = line.substring(spaceIndex + 1)
			
			if(value == "true" || value == '"true"'){
				currentObj[name] = true
			}else if(value == "false" || value == '"false"'){
				currentObj[name] = false
			}else if(value[0] == '"'){
				currentObj[name] = value.substring(1,value.length - 1)
			}else if(value[0] == '{'){
				currentObj[name] = value.substring(1,value.length - 1).split(/[ \t]+/g)
			}else{
				var number = parseFloat(value)
				if(isNaN(number)){
					currentObj[name] = value
				}else{
					currentObj[name] = number
				}
			}
		}
	}
	return output
}


module.exports = {
	getRawMachineInfo,
	//getRawMachineInfo: async function(){
	//	return require("./testing/out/example.js").exampleData
	//},
	parser,
}
	