/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.nbtedit.nbt;

import com.mcf.davidee.nbtedit.NBTEdit;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SaveStates {
    private File file;
    private SaveState[] tags;

    public SaveStates(File file) {
        this.file = file;
        this.tags = new SaveState[7];
        for (int i = 0; i < 7; ++i) {
            this.tags[i] = new SaveState("Slot " + (i + 1));
        }
    }

    public void read() throws IOException {
        if (this.file.exists() && this.file.canRead()) {
            NBTTagCompound root = CompressedStreamTools.func_74797_a((File)this.file);
            for (int i = 0; i < 7; ++i) {
                String name = "slot" + (i + 1);
                if (root.func_74764_b(name)) {
                    this.tags[i].tag = root.func_74775_l(name);
                }
                if (!root.func_74764_b(name + "Name")) continue;
                this.tags[i].name = root.func_74779_i(name + "Name");
            }
        }
    }

    public void write() throws IOException {
        NBTTagCompound root = new NBTTagCompound();
        for (int i = 0; i < 7; ++i) {
            root.func_74782_a("slot" + (i + 1), (NBTBase)this.tags[i].tag);
            root.func_74778_a("slot" + (i + 1) + "Name", this.tags[i].name);
        }
        CompressedStreamTools.func_74795_b((NBTTagCompound)root, (File)this.file);
    }

    public void save() {
        try {
            this.write();
            NBTEdit.log(Level.FINE, "NBTEdit saved successfully.");
        }
        catch (IOException e) {
            NBTEdit.log(Level.WARNING, "Unable to write NBTEdit save.");
            NBTEdit.throwing("SaveStates", "save", e);
        }
    }

    public void load() {
        try {
            this.read();
            NBTEdit.log(Level.FINE, "NBTEdit save loaded successfully.");
        }
        catch (IOException e) {
            NBTEdit.log(Level.WARNING, "Unable to read NBTEdit save.");
            NBTEdit.throwing("SaveStates", "load", e);
        }
    }

    public SaveState getSaveState(int index) {
        return this.tags[index];
    }

    public static final class SaveState {
        public String name;
        public NBTTagCompound tag;

        public SaveState(String name) {
            this.name = name;
            this.tag = new NBTTagCompound();
        }
    }
}

